from LAN_Controller import *
import time
import struct

class Agilent_N5230A(LAN_Controller):
    def __init__(self, hostname):
        LAN_Controller.__init__(self,hostname)
        self.command('SYST:FPR')    # reset


    def prepRangeMeasurement(self, freq, ifbw):
        self.command("CALC1:PAR:DEF 'myMeas',S21")
        self.command("SENSE:SWEEP:TYPE CW")
        self.command("SENS1:FREQ:CENT " + str(freq) + "ghz")
        self.command("SENS:BAND " + str(ifbw))
        self.command("SENS1:SWE:POIN 1")
        self.command("SENS1:SWE:GEN ANAL")
        self.command("SENS1:SWE:TIME:AUTO ON")
        self.command("TRIG:SOUR MAN")
        self.command("SENS1:SWE:MODE HOLD")
        self.command("FORM ASCii,0")

    def prepFastRangeMeasurement(self, freq, ifbw):
        self.command("CALC1:PAR:DEF 'myMeas',S21")
        self.command("SENSE:SWEEP:TYPE CW")
        self.command("SENS1:FREQ:CENT " + str(freq) + "ghz")
        self.command("SENS:BAND " + str(ifbw))
        self.command("SENS1:SWE:MODE CONT")
        self.command("SENS1:SWE:POIN 120")
        self.command("SENS1:SWE:GEN ANAL")
        self.command("SENS1:SWE:TIME:AUTO ON")

        self.command("TRIG:SOUR MAN")
        self.command("TRIG:SCOP CURR")
        self.command("SENS1:SWE:TRIG:POIN ON")

        self.command("FORM REAL,64")

        print self.getSweepTime()


    def getSweepTime(self):
        return self.query("SENS1:SWE:TIME?")

    def measure(self):
        self.query("INIT:IMM;*OPC?")
        return float(self.query("CALC:DATA? FDATA"))

    def fastMeasure(self):
        self.command("INIT1:IMM;*WAI")
        time.sleep(0.001)

    def blockTimer(self,time):
        i = time/0.0000001
        while i > 0:
            i -= 1

    def pullData(self):
        packet_str = self.query("CALC:DATA? FDATA")
        num_dig_count = int(packet_str[1])
        data_start_idx = 2+num_dig_count
        num_bytes = int(packet_str[2:data_start_idx])
        print num_bytes
        data_str = packet_str[data_start_idx:(data_start_idx+num_bytes)]
        data = []
        print len(data_str)
        for i in range(0,len(data_str),8):
            unpacked_byte = struct.unpack('>d', data_str[i:(i+8)])
            data.append(float(unpacked_byte[0]))
        return data
